package com.treweren.save;

import java.awt.FlowLayout;
import javax.swing.JFileChooser;

import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponentBoolean;
import org.knime.core.node.defaultnodesettings.DialogComponentFileChooser;
import org.knime.core.node.defaultnodesettings.DialogComponentNumber;
import org.knime.core.node.defaultnodesettings.DialogComponentString;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelIntegerBounded;
import org.knime.core.node.defaultnodesettings.SettingsModelString;




/**
 * <code>NodeDialog</code> for the "Save" Node.
 * Saves molecular data to disk file
 *
 * This node dialog derives from {@link DefaultNodeSettingsPane} which allows
 * creation of a simple dialog with standard components. If you need a more 
 * complex dialog please derive directly from 
 * {@link org.knime.core.node.NodeDialogPane}.
 * 
 * @author Treweren Consultants
 */
public class SaveNodeDialog extends DefaultNodeSettingsPane {

    /**
     * New pane for configuring Save node dialog.
     * This is just a suggestion to demonstrate possible default dialog
     * components.
     */
    protected SaveNodeDialog() {
        super();
        
        DialogComponentFileChooser c_save = new DialogComponentFileChooser(
                new SettingsModelString (
                        SaveNodeModel.CFGKEY_SAVE,
                        SaveNodeModel.DEFAULT_SAVE ),
                        "Save file", JFileChooser.SAVE_DIALOG, ".smi", ".csv", ".smiles", ".pdb", ".sdf" );
        addDialogComponent(c_save );
        c_save.setToolTipText("The molecules are written to this file");
        c_save.setBorderTitle("Save file of molecules");

        DialogComponentBoolean c_hydrogens = new DialogComponentBoolean(
                new SettingsModelBoolean (
                        SaveNodeModel.CFGKEY_HYDROGENS,
                        SaveNodeModel.DEFAULT_HYDROGENS),
                        "Include hydrogens in SD file" );
        addDialogComponent(c_hydrogens);
        c_hydrogens.getComponentPanel().setLayout( new FlowLayout(0));
        c_hydrogens.setToolTipText("Hydrogens may be included or excluded from SD files");

    	createNewTab("THINK setup");
    	
        DialogComponentBoolean c_column = new DialogComponentBoolean(
                new SettingsModelBoolean (
                        SaveNodeModel.CFGKEY_SMILES,
                        SaveNodeModel.DEFAULT_SMILES),
                        "Use SMILES in preference to SD column" );
        addDialogComponent(c_column);
        c_column.getComponentPanel().setLayout( new FlowLayout(0));
        c_column.setToolTipText("The molecule data is transferred to THINK using SD or SMILES format depending on this setting");
        
        DialogComponentString c_working = new DialogComponentString(
                new SettingsModelString (
                        SaveNodeModel.CFGKEY_WORKING,
                        SaveNodeModel.DEFAULT_WORKING),
                        "Working folder" );
        addDialogComponent(c_working);
        c_working.getComponentPanel().setLayout( new FlowLayout(2));
        c_working.setToolTipText("The temporary files used to transfer the data to and from THINK are placed in this folder");
                    
    }
}
