package com.treweren.parent;

import java.awt.FlowLayout;

import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponentBoolean;
import org.knime.core.node.defaultnodesettings.DialogComponentNumber;
import org.knime.core.node.defaultnodesettings.DialogComponentString;
import org.knime.core.node.defaultnodesettings.DialogComponentDoubleRange;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelIntegerBounded;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.defaultnodesettings.SettingsModelDoubleRange;
import org.knime.core.node.defaultnodesettings.SettingsModelDoubleBounded;


/**
 * <code>NodeDialog</code> for the "Parent" Node.
 * Convert to parent form and apply drug-like filters
 *
 * This node dialog derives from {@link DefaultNodeSettingsPane} which allows
 * creation of a simple dialog with standard components. If you need a more 
 * complex dialog please derive directly from 
 * {@link org.knime.core.node.NodeDialogPane}.
 * 
 * @author Treweren Consultants
 */
public class ParentNodeDialog extends DefaultNodeSettingsPane {

    /**
     * New pane for configuring Parent node dialog.
     * This is just a suggestion to demonstrate possible default dialog
     * components.
     */
    protected ParentNodeDialog() {
        super();
        DialogComponentBoolean c_filter =new DialogComponentBoolean(
                new SettingsModelBoolean (
                        ParentNodeModel.CFGKEY_FILTER,
                        ParentNodeModel.DEFAULT_FILTER),"Apply drug-like filters" ); 
        addDialogComponent(c_filter);
        c_filter.setToolTipText("Eliminates molecules which have properties which are not drug-like");
        c_filter.getComponentPanel().setLayout( new FlowLayout(0));
        
        DialogComponentDoubleRange c_centres = new DialogComponentDoubleRange (
        		new SettingsModelDoubleRange (ParentNodeModel.CFGKEY_CENTRES, ParentNodeModel.DEFAULT_CENTRE1, ParentNodeModel.DEFAULT_CENTRE2),
        		 0., 10., 1., 0., 10., 1., "Interaction Centres");
        addDialogComponent(c_centres);        		
        c_centres.setToolTipText("Eliminate molecules with an interaction centres count outside the range");
        c_centres.getComponentPanel().setLayout( new FlowLayout(2));
        
        DialogComponentDoubleRange c_mass = new DialogComponentDoubleRange(
        		new SettingsModelDoubleRange( ParentNodeModel.CFGKEY_MASS, ParentNodeModel.DEFAULT_MASS1, ParentNodeModel.DEFAULT_MASS2),
        		0.,1000., 10., 0., 1000., 10., "Molecular mass");
        
        addDialogComponent(c_mass);
        c_mass.setToolTipText("Eliminate molecules with a molecular mass outside the range");
        c_mass.getComponentPanel().setLayout( new FlowLayout(2));
        
        DialogComponentDoubleRange c_xsa = new DialogComponentDoubleRange(
        		new SettingsModelDoubleRange( ParentNodeModel.CFGKEY_XSA, ParentNodeModel.DEFAULT_XSA1, ParentNodeModel.DEFAULT_XSA2),
        		0.,1000., 10., 0., 1000., 10., "N+O surface area");
        
        addDialogComponent(c_xsa);
        c_xsa.setToolTipText("Eliminate molecules with a N+O surface area outside the range");
        c_xsa.getComponentPanel().setLayout( new FlowLayout(2));
        
        DialogComponentDoubleRange c_rotbonds = new DialogComponentDoubleRange(
        		new SettingsModelDoubleRange( ParentNodeModel.CFGKEY_ROTBONDS, ParentNodeModel.DEFAULT_ROTBONDS1, ParentNodeModel.DEFAULT_ROTBONDS2),
        		0.,100., 1., 0., 100., 1., "Rotatable bonds");
        
        addDialogComponent(c_rotbonds);
        c_rotbonds.setToolTipText("Eliminate molecules with a rotatable bond count outside the range");
        c_rotbonds.getComponentPanel().setLayout( new FlowLayout(2));


        createNewTab("THINK setup");
        
        DialogComponentBoolean c_column = new DialogComponentBoolean(
                new SettingsModelBoolean (
                        ParentNodeModel.CFGKEY_SMILES,
                        ParentNodeModel.DEFAULT_SMILES),
                        "Use SMILES in preference to SD column" );
        addDialogComponent(c_column);
        c_column.getComponentPanel().setLayout( new FlowLayout(0));
        c_column.setToolTipText("The molecule data is transferred to THINK using SD or SMILES format depending on this setting");
        
        DialogComponentString c_working = new DialogComponentString(
                new SettingsModelString (
                        ParentNodeModel.CFGKEY_WORKING,
                        ParentNodeModel.DEFAULT_WORKING),
                        "Working folder" );
        addDialogComponent(c_working);
        c_working.getComponentPanel().setLayout( new FlowLayout(2));
        c_working.setToolTipText("The temporary files used to transfer the data to and from THINK are placed in this folder");

    }
}
