package com.treweren.cluster;

import java.awt.FlowLayout;

import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponentBoolean;
import org.knime.core.node.defaultnodesettings.DialogComponentNumber;
import org.knime.core.node.defaultnodesettings.DialogComponentString;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.defaultnodesettings.SettingsModelDoubleBounded;
import org.knime.core.node.defaultnodesettings.SettingsModelIntegerBounded;


/**
 * <code>NodeDialog</code> for the "Cluster" Node.
 * Clusters molecules based on functional group similarity
 *
 * This node dialog derives from {@link DefaultNodeSettingsPane} which allows
 * creation of a simple dialog with standard components. If you need a more 
 * complex dialog please derive directly from 
 * {@link org.knime.core.node.NodeDialogPane}.
 * 
 * @author Treweren Consultants
 */
public class ClusterNodeDialog extends DefaultNodeSettingsPane {

    /**
     * New pane for configuring Cluster node dialog.
     * This is just a suggestion to demonstrate possible default dialog
     * components.
     */
    protected ClusterNodeDialog() {
        super();
        
        DialogComponentNumber c_count = new DialogComponentNumber(
                new SettingsModelIntegerBounded(
                    ClusterNodeModel.CFGKEY_COUNT,
                    ClusterNodeModel.DEFAULT_COUNT,
                    Integer.MIN_VALUE, Integer.MAX_VALUE),
                    "Required number of clusters", /*step*/ 1, /*componentwidth*/ 5);
        
        addDialogComponent(c_count);
        c_count.getComponentPanel().setLayout( new FlowLayout(2));
        c_count.setToolTipText("If the number of clusters=0 then the number of resulting clusters is determined by the cluster similarity");

        DialogComponentNumber c_cutoff = new DialogComponentNumber(
                new SettingsModelDoubleBounded (
                    ClusterNodeModel.CFGKEY_CUTOFF,
                    ClusterNodeModel.DEFAULT_CUTOFF, 0., 1. ),
                    "Cluster similarity", .05, 5 );
        addDialogComponent(c_cutoff );
        c_cutoff.getComponentPanel().setLayout( new FlowLayout(2));
        c_cutoff.setToolTipText("Molecules are placed in the same cluster if they are more similar than the cutoff");

         createNewTab("THINK setup");         

         DialogComponentBoolean c_column = new DialogComponentBoolean(
                 new SettingsModelBoolean (
                         ClusterNodeModel.CFGKEY_SMILES,
                         ClusterNodeModel.DEFAULT_SMILES),
                         "Use SMILES in preference to SD column" );
         addDialogComponent(c_column);
         c_column.getComponentPanel().setLayout( new FlowLayout(0));
         c_column.setToolTipText("The molecule data is transferred to THINK using SD or SMILES format depending on this setting");
   
         DialogComponentString c_working = new DialogComponentString(
                 new SettingsModelString (
                         ClusterNodeModel.CFGKEY_WORKING,
                         ClusterNodeModel.DEFAULT_WORKING),
                         "Working folder" );
         addDialogComponent(c_working);
         c_working.getComponentPanel().setLayout( new FlowLayout(2));
         c_working.setToolTipText("The temporary files used to transfer the data to and from THINK are placed in this folder");
         
    }
}
