package com.treweren.fingerprint;

import java.awt.FlowLayout;

import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponentBoolean;
import org.knime.core.node.defaultnodesettings.DialogComponentNumber;
import org.knime.core.node.defaultnodesettings.DialogComponentString;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelIntegerBounded;
import org.knime.core.node.defaultnodesettings.SettingsModelString;


/**
 * <code>NodeDialog</code> for the "Fingerprint" Node.
 * Calculation of functional group fingerprint
 *
 * This node dialog derives from {@link DefaultNodeSettingsPane} which allows
 * creation of a simple dialog with standard components. If you need a more 
 * complex dialog please derive directly from 
 * {@link org.knime.core.node.NodeDialogPane}.
 * 
 * @author Treweren Consultants
 */
public class FingerprintNodeDialog extends DefaultNodeSettingsPane {

    /**
     * New pane for configuring Fingerprint node dialog.
     * This is just a suggestion to demonstrate possible default dialog
     * components.
     */
    protected FingerprintNodeDialog() {
        super();
        
        DialogComponentBoolean c_fpmode = new DialogComponentBoolean(
                new SettingsModelBoolean (
                        FingerprintNodeModel.CFGKEY_FPMODE,
                        FingerprintNodeModel.DEFAULT_FPMODE),
                        "Store fingerprint as separate columns" );
        addDialogComponent(c_fpmode);
        c_fpmode.setToolTipText("For some statistical tools/nodes it is necessary to have expanded fingerprints into separate columns");

        createNewTab("THINK setup");         

        DialogComponentBoolean c_column = new DialogComponentBoolean(
                new SettingsModelBoolean (
                        FingerprintNodeModel.CFGKEY_SMILES,
                        FingerprintNodeModel.DEFAULT_SMILES),
                        "Use SMILES in preference to SD column" );
        addDialogComponent(c_column);
        c_column.getComponentPanel().setLayout( new FlowLayout(0));
        c_column.setToolTipText("The molecule data is transferred to THINK using SD or SMILES format depending on this setting");

        DialogComponentString c_working = new DialogComponentString(
                new SettingsModelString (
                        FingerprintNodeModel.CFGKEY_WORKING,
                        FingerprintNodeModel.DEFAULT_WORKING),
                        "Working folder" );
        addDialogComponent(c_working);
        c_working.getComponentPanel().setLayout( new FlowLayout(2));
        c_working.setToolTipText("The temporary files used to transfer the data to and from THINK are placed in this folder");
}
}
