package com.treweren.open;

import javax.swing.JFileChooser;
import java.awt.FlowLayout;

import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponentBoolean;
import org.knime.core.node.defaultnodesettings.DialogComponentFileChooser;
import org.knime.core.node.defaultnodesettings.DialogComponentNumber;
import org.knime.core.node.defaultnodesettings.DialogComponentString;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelIntegerBounded;
import org.knime.core.node.defaultnodesettings.SettingsModelString;



/**
 * <code>NodeDialog</code> for the "Open" Node.
 * Read various molecular file formats
 *
 * This node dialog derives from {@link DefaultNodeSettingsPane} which allows
 * creation of a simple dialog with standard components. If you need a more 
 * complex dialog please derive directly from 
 * {@link org.knime.core.node.NodeDialogPane}.
 * 
 * @author Treweren Consultants
 */
public class OpenNodeDialog extends DefaultNodeSettingsPane {

    /**
     * New pane for configuring Open node dialog.
     * This is just a suggestion to demonstrate possible default dialog
     * components.
     */
    protected OpenNodeDialog() {
        super();
        
        DialogComponentFileChooser c_open = new DialogComponentFileChooser(
                new SettingsModelString (
                        OpenNodeModel.CFGKEY_OPEN,
                        OpenNodeModel.DEFAULT_OPEN ),
                        "Open file", JFileChooser.OPEN_DIALOG, "smi", "csv", "smiles", "pdb","sdf" );
        addDialogComponent(c_open );
        c_open.setToolTipText("The molecules being read are in this file");
        c_open.setBorderTitle("Open file of molecules");

        DialogComponentString c_name = new DialogComponentString(
                new SettingsModelString (
                        OpenNodeModel.CFGKEY_NAME,
                        OpenNodeModel.DEFAULT_NAME),
                        "Data field for row name" );
        addDialogComponent(c_name);
        c_name.getComponentPanel().setLayout( new FlowLayout(0));
        c_name.setToolTipText("For MACCS SD files, the row name is taken from the specified field");

        DialogComponentBoolean c_hydrogens = new DialogComponentBoolean(
                new SettingsModelBoolean (
                        OpenNodeModel.CFGKEY_HYDROGENS,
                        OpenNodeModel.DEFAULT_HYDROGENS),
                        "Add hydrogens" );
        addDialogComponent(c_hydrogens);
        c_hydrogens.getComponentPanel().setLayout( new FlowLayout(0));
        c_hydrogens.setToolTipText("Hydrogens may be automatically added where they are not explicitly present in the data file");
/*
        createNewTab("Advanced");
              
        DialogComponentString c_group1 = new DialogComponentString(
                new SettingsModelString (
                    OpenNodeModel.CFGKEY_GROUP1,
                    OpenNodeModel.DEFAULT_GROUP1),
                    "Atoms for group 1" );
        addDialogComponent(c_group1);
        c_group1.getComponentPanel().setLayout( new FlowLayout(0));
        c_group1.setToolTipText("Comma separated list of atoms for group eg C(); C(23),N(24)");

        DialogComponentString c_group2 = new DialogComponentString(
                new SettingsModelString (
                    OpenNodeModel.CFGKEY_GROUP2,
                    OpenNodeModel.DEFAULT_GROUP2),
                    "Atoms for group 2" );
        addDialogComponent(c_group2);
        c_group2.getComponentPanel().setLayout( new FlowLayout(0));
        c_group2.setToolTipText("Comma separated list of atoms for group eg C(); C(23),N(24)");

        DialogComponentString c_group3 = new DialogComponentString(
                new SettingsModelString (
                    OpenNodeModel.CFGKEY_GROUP3,
                    OpenNodeModel.DEFAULT_GROUP3),
                    "Atoms for group 3" );
        addDialogComponent(c_group3);
        c_group3.getComponentPanel().setLayout( new FlowLayout(0));
        c_group3.setToolTipText("Comma separated list of atoms for group eg C(); C(23),N(24)");

        DialogComponentString c_group4 = new DialogComponentString(
                new SettingsModelString (
                    OpenNodeModel.CFGKEY_GROUP4,
                    OpenNodeModel.DEFAULT_GROUP4),
                    "Atoms for group 4" );
        addDialogComponent(c_group4);
        c_group4.getComponentPanel().setLayout( new FlowLayout(0));
        c_group4.setToolTipText("Comma separated list of atoms for group eg C(); C(23),N(24)");

*/        
    	createNewTab("THINK setup");         

        DialogComponentString c_working = new DialogComponentString(
                new SettingsModelString (
                        OpenNodeModel.CFGKEY_WORKING,
                        OpenNodeModel.DEFAULT_WORKING),
                        "Working folder" );
        addDialogComponent(c_working);
        c_working.getComponentPanel().setLayout( new FlowLayout(2));
        c_working.setToolTipText("The temporary files used to transfer the data to and from THINK are placed in this folder");
    }
    
}