package com.treweren.search;

import java.io.File;

import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeView;

/**
 * <code>NodeView</code> for the "Search" Node.
 * Search
 *
 * @author Treweren Consultants
 */
public class SearchNodeView extends NodeView {

    /**
     * Creates a new view.
     * 
     * @param nodeModel The model (class: {@link SearchNodeModel})
     */
    private static final NodeLogger logger = NodeLogger
    .getLogger(SearchNodeView.class);

    protected SearchNodeView(final NodeModel nodeModel) {
        super(nodeModel);

        String cmdString = System.getenv("THINK_EXEC") + "think THINK_EXEC:display.log output.log search.sdf None None 3D 0 None 0.6" ; 
        final String cwdString = System.getenv("THINK_WORKING");
        File cwdFile = new File (cwdString);
        Runtime rt = Runtime.getRuntime();
        try {
        final Process proc = rt.exec(cmdString, null, cwdFile);
        int exitVal = proc.waitFor();
        } catch (Throwable t) {
            logger.error("THINK failed (with exception)", t);
        }
     }

    /**
     * @see org.knime.core.node.NodeView#modelChanged()
     */
    @Override
    protected void modelChanged() {

		// TODO retrieve the new model from your nodemodel and 
		// update the view.
		SearchNodeModel nodeModel = 
			(SearchNodeModel)getNodeModel();
		assert nodeModel != null;
		
		// be aware of a possibly not executed nodeModel! The data you retrieve
		// from your nodemodel could be null, emtpy, or invalid in any kind.
		
    }

    /**
     * @see org.knime.core.node.NodeView#onClose()
     */
    @Override
    protected void onClose() {
    
    	// TODO things to do when closing the view
    }

    /**
     * @see org.knime.core.node.NodeView#onOpen()
     */
    @Override
    protected void onOpen() {

        // TODO things to do when opening the view
    }

}
