package com.treweren.enumeration;

import java.awt.FlowLayout;

import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponentBoolean;
import org.knime.core.node.defaultnodesettings.DialogComponentNumber;
import org.knime.core.node.defaultnodesettings.DialogComponentString;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelIntegerBounded;
import org.knime.core.node.defaultnodesettings.SettingsModelString;




/**
 * <code>NodeDialog</code> for the "Enumeration" Node.
 * Enumerate a combinatorial library
 *
 * This node dialog derives from {@link DefaultNodeSettingsPane} which allows
 * creation of a simple dialog with standard components. If you need a more 
 * complex dialog please derive directly from 
 * {@link org.knime.core.node.NodeDialogPane}.
 * 
 * @author Treweren Consultants
 */
public class EnumerationNodeDialog extends DefaultNodeSettingsPane {

    /**
     * New pane for configuring Enumeration node dialog.
     * This is just a suggestion to demonstrate possible default dialog
     * components.
     */
    protected EnumerationNodeDialog() {
        super();
        
        DialogComponentNumber c_rgroup = new DialogComponentNumber(
                new SettingsModelIntegerBounded(
                        EnumerationNodeModel.CFGKEY_RGROUP,
                        EnumerationNodeModel.DEFAULT_RGROUP,
                        1, 4),
                        "Number of R-groups:", /*step*/ 1, /*componentwidth*/ 1);
        addDialogComponent(c_rgroup);
        c_rgroup.setToolTipText("The number of R-group must match the number of R-group inputs (ignoring the reaction)");
        c_rgroup.getComponentPanel().setLayout( new FlowLayout(0));

        DialogComponentBoolean c_filter = new DialogComponentBoolean(
                new SettingsModelBoolean (
                        EnumerationNodeModel.CFGKEY_FILTER,
                        EnumerationNodeModel.DEFAULT_FILTER),
                        "Apply drug-like filters" );
        addDialogComponent(c_filter);
        c_filter.setToolTipText("Eliminates molecules which have properties which are not drug-like");
        c_filter.getComponentPanel().setLayout( new FlowLayout(0));

        createNewTab("Advanced");
        
        DialogComponentString c_group1 = new DialogComponentString(
                new SettingsModelString (
                    EnumerationNodeModel.CFGKEY_GROUP1,
                    EnumerationNodeModel.DEFAULT_GROUP1),
                    "Atom for R-group 1 attachment" );
        addDialogComponent(c_group1);
        c_group1.getComponentPanel().setLayout( new FlowLayout(0));
        c_group1.setToolTipText("A single atom in the core should be referenced eg C1, C(5), N(21) (only if the attachment atom/position is missing)");

        DialogComponentString c_group2 = new DialogComponentString(
                new SettingsModelString (
                    EnumerationNodeModel.CFGKEY_GROUP2,
                    EnumerationNodeModel.DEFAULT_GROUP2),
                    "Atom for R-group 2 attachment" );
        addDialogComponent(c_group2);
        c_group2.getComponentPanel().setLayout( new FlowLayout(0));
        c_group2.setToolTipText("A single atom in the core should be referenced eg C1, C(5), N(21) (only if the attachment atom/position is missing)");

        DialogComponentString c_group3 = new DialogComponentString(
                new SettingsModelString (
                    EnumerationNodeModel.CFGKEY_GROUP3,
                    EnumerationNodeModel.DEFAULT_GROUP3),
                    "Atom for R-group 3 attachment" );
        addDialogComponent(c_group3);
        c_group3.getComponentPanel().setLayout( new FlowLayout(0));
        c_group3.setToolTipText("A single atom in the core should be referenced eg C1, C(5), N(21) (only if the attachment atom/position is missing)");

        DialogComponentString c_group4 = new DialogComponentString(
                new SettingsModelString (
                    EnumerationNodeModel.CFGKEY_GROUP4,
                    EnumerationNodeModel.DEFAULT_GROUP4),
                    "Atom for R-group 4 attachment" );
        addDialogComponent(c_group4);
        c_group4.getComponentPanel().setLayout( new FlowLayout(0));
        c_group4.setToolTipText("A single atom in the core should be referenced eg C1, C(5), N(21) (only if the attachment atom/position is missing)");


        createNewTab("THINK setup");         

        DialogComponentBoolean c_column = new DialogComponentBoolean(
                new SettingsModelBoolean (
                        EnumerationNodeModel.CFGKEY_SMILES,
                        EnumerationNodeModel.DEFAULT_SMILES),
                        "Use SMILES in preference to SD column" );
        addDialogComponent(c_column);
        c_column.getComponentPanel().setLayout( new FlowLayout(0));
        c_column.setToolTipText("The molecule data is transferred to THINK using SD or SMILES format depending on this setting");
        
        DialogComponentNumber c_site = new DialogComponentNumber(
                new SettingsModelIntegerBounded (
                        EnumerationNodeModel.CFGKEY_ROW,
                        EnumerationNodeModel.DEFAULT_ROW, 1, Integer.MAX_VALUE),
                        "Site row",1, 2 );
        
        addDialogComponent(c_site);
        c_site.getComponentPanel().setLayout( new FlowLayout(0));
        c_site.setToolTipText("The data transferred will be limited to one site");
 
        DialogComponentString c_working = new DialogComponentString(
                new SettingsModelString (
                        EnumerationNodeModel.CFGKEY_WORKING,
                        EnumerationNodeModel.DEFAULT_WORKING),
                        "Working folder" );
        addDialogComponent(c_working);
        c_working.getComponentPanel().setLayout( new FlowLayout(2));
        c_working.setToolTipText("The temporary files used to transfer the data to and from THINK are placed in this folder");
      
                   
    }
}
