package com.treweren.rgroups;

import java.awt.FlowLayout;

import javax.swing.JFileChooser;

import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponentBoolean;
import org.knime.core.node.defaultnodesettings.DialogComponentFileChooser;
import org.knime.core.node.defaultnodesettings.DialogComponentNumber;
import org.knime.core.node.defaultnodesettings.DialogComponentString;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelIntegerBounded;
import org.knime.core.node.defaultnodesettings.SettingsModelString;



/**
 * <code>NodeDialog</code> for the "Rgroups" Node.
 * Performs R-group search
 *
 * This node dialog derives from {@link DefaultNodeSettingsPane} which allows
 * creation of a simple dialog with standard components. If you need a more 
 * complex dialog please derive directly from 
 * {@link org.knime.core.node.NodeDialogPane}.
 * 
 * @author Treweren Consultants
 */
public class RgroupsNodeDialog extends DefaultNodeSettingsPane {

    /**
     * New pane for configuring Rgroups node dialog.
     * This is just a suggestion to demonstrate possible default dialog
     * components.
     */
    protected RgroupsNodeDialog() {
        super();
        
        DialogComponentFileChooser c_search = new DialogComponentFileChooser(
                new SettingsModelString (
                        RgroupsNodeModel.CFGKEY_SEARCH,
                        RgroupsNodeModel.DEFAULT_SEARCH ),
                        "Search file", JFileChooser.OPEN_DIALOG, "smi", "sdf", "smiles" );
        addDialogComponent(c_search);
        c_search.setToolTipText("The reagent molecules being searched are in this file");

        
        DialogComponentNumber c_rgroup = new DialogComponentNumber(
                new SettingsModelIntegerBounded(
                        RgroupsNodeModel.CFGKEY_RGROUP,
                        RgroupsNodeModel.DEFAULT_RGROUP,
                        1, 8),
                        "R-group number:", /*step*/ 1, /*componentwidth*/ 1);
        addDialogComponent(c_rgroup);
        
        c_rgroup.setToolTipText("A separate search is performed for each R-group in the reaction");
        c_rgroup.getComponentPanel().setLayout( new FlowLayout(2));
        DialogComponentBoolean c_filter = new DialogComponentBoolean(
                new SettingsModelBoolean (
                        RgroupsNodeModel.CFGKEY_FILTER,
                        RgroupsNodeModel.DEFAULT_FILTER),
                        "Apply drug-like filters" );
        addDialogComponent(c_filter);
        c_filter.setToolTipText("Eliminates molecules which have properties which are not drug-like");
        c_filter.getComponentPanel().setLayout( new FlowLayout(0));
        
        final DialogComponentBoolean c_parent = new DialogComponentBoolean(
                new SettingsModelBoolean (
                        RgroupsNodeModel.CFGKEY_PARENT,
                        RgroupsNodeModel.DEFAULT_PARENT),
                        "Convert salts to parent form" );
        addDialogComponent(c_parent);
        c_parent.setToolTipText("Converts molecules to parent(neutral) form and eliminates counter-ions(salts)");
        c_parent.getComponentPanel().setLayout( new FlowLayout(0));

        createNewTab("THINK setup");         

        DialogComponentBoolean c_column = new DialogComponentBoolean(
                new SettingsModelBoolean (
                        RgroupsNodeModel.CFGKEY_SMILES,
                        RgroupsNodeModel.DEFAULT_SMILES),
                        "Use SMILES in preference to SD column" );
        addDialogComponent(c_column);
        c_column.getComponentPanel().setLayout( new FlowLayout(0));
        c_column.setToolTipText("The molecule data is transferred to THINK using SD or SMILES format depending on this setting");
         
        DialogComponentString c_working = new DialogComponentString(
                new SettingsModelString (
                        RgroupsNodeModel.CFGKEY_WORKING,
                        RgroupsNodeModel.DEFAULT_WORKING),
                        "Working folder" );
        addDialogComponent(c_working);
        c_working.getComponentPanel().setLayout( new FlowLayout(2));
        c_working.setToolTipText("The temporary files used to transfer the data to and from THINK are placed in this folder");
        

    }
}
